Triggers = {}
CollectionsUsed = {12}
moving_ephemera = {}

function Triggers.init()
    enabled = Game.version > "20200904"
end

function Triggers.idle()
    if enabled then
        for i = #moving_ephemera, 1, -1 do
            local e = update_ephemera(moving_ephemera[i])
            if not e then
                table.remove(moving_ephemera, i)
            end
        end
    end
end

function Triggers.monster_killed(monster, aggressor_player, projectile)
    if enabled then
        if not monster._killed_count then
            monster._killed_count = 1
        else
            monster._killed_count = monster._killed_count + 1
        end

        if monster._killed_count > 2 then
            return
        end

        if projectile then
            local explode = 0
            if
                projectile.type == "grenade" or projectile.type == "compiler bolt minor" or
                    projectile.type == "compiler bolt major" or
                    projectile.type == "fusion bolt major" or
                    projectile.type == "juggernaut rocket" or
                    projectile.type == "trooper grenade" or
                    projectile.type == "juggernaut missile" or
                    projectile.type == "overloaded fusion disperal"
             then
                explode = 1
            end
            if monster.type.class == "cyborg" or monster.type == "mother of all hunters" then
                explode = 1
            elseif monster.type.class == "hunter" and projectile.type == "fusion bolt minor" then
                explode = 1
            end
            if projectile.type == "missile" then
                explode = 2
            end
            if projectile.type == "flamethrower burst" or projectile.type == "alien weapon" then
                local c = monster.type.class
                if c == "player" or c == "bob" or c == "fighter" or c == "trooper" or c == "enforcer" or c == "explodabob" then
                    explode = 3
                end
            end
            explode_monster(monster, explode, projectile.facing)
        else
            explode = 1
            if monster._killed_count == 2 then
                local c = monster.type.class
                if c == "player" or c == "bob" or c == "fighter" or c == "trooper" or c == "enforcer" or c == "explodabob" then
                    explode = 3
                end
            end
            explode_monster(monster, explode)
        end
    end
end

function explode_monster(m, explode, proj_facing)
    if Ephemera.quality == "off" then
        return
    end

    local col, seq, ct, num = get_ephemera_by_monster(m)

    if Ephemera.quality == "ultra" then
        num = num * 4
    elseif Ephemera.quality == "high" then
        -- elseif Ephemera.quality == "medium" then
        num = num * 2
    elseif Ephemera.quality == "low" then
        num = math.ceil(num * .5)
    end

    if col and seq and ct then
        for i = 1, num do
            if explode == 3 then -- Get a new random sequence for each ephemera
                col, seq, ct, num = get_ephemera_by_flaming_death(m)
            end
            local facing = nil
            if proj_facing and m.type.class ~= "compiler" then
                local rand = -45 + Game.random_local(90)
                facing = proj_facing + rand
            else
                facing = Game.random_local(360)
            end
            local e = Ephemera.new(m.x, m.y, m.z + .2 + Game.random_local(5) / 10.0, m.polygon, col, seq, facing)
            if not e then
                cleanup()
                e = Ephemera.new(m.x, m.y, m.z + .2 + Game.random_local(5) / 10.0, m.polygon, col, seq, facing)
            end

            if e then
                table.insert(moving_ephemera, e)

                if m.type == "mother of all cyborgs" or m.type == "mother of all hunters" then
                    e.enlarged = true
                end

                e._horizontal_dist = Game.random_local(100) / 750.0
                if explode == 1 then
                    e._vertical_velocity = .05 + (Game.random_local(5) / 100.0)
                elseif explode == 2 then
                    e._vertical_velocity = .08 + (Game.random_local(5) / 100.0)
                    e._horizontal_dist = (50 + Game.random_local(50)) / 300.0
                elseif explode == 3 then
                    e._vertical_velocity = .02
                else
                    e._vertical_velocity = .01
                end
                e._vertical_velocity_step = -.002
                e._terminal_velocity = -.09
                e._max_bounces = 2
                e._bounces = 0
                e._moving_horizontally = true
                e._active = true
                e.clut_index = ct

                if m.type.class == "compiler" then
                    local z = m.z + (Game.random_local(85) / 100)
                    e:position(e.x, e.y, z, e.polygon)
                    e._vertical_velocity = Game.random_local(15) / 1000
                    if Game.random_local(2) == 0 then
                        e._vertical_velocity = e._vertical_velocity * -1
                    end
                    e._vertical_velocity_step = 0
                    e._terminal_velocity = 0
                    e._horizontal_dist = .005 + (Game.random_local(10) / 1000)
                end

                if m.type.class == "defender" then
                    e._delete_tick = Game.ticks + 35
                elseif m.type.class == "compiler" then
                    e._delete_tick = Game.ticks + 5 + Game.random_local(40)
                end
            end
        end
    end
end

function update_ephemera(e)
    if not e._active then
        return nil
    end

    if e._delete_tick and e._delete_tick == Game.ticks then
        e:delete()
        return nil
    end

    if e.z > e.polygon.floor.z or e._vertical_velocity > 0 then
        local vv = e._vertical_velocity + e._vertical_velocity_step
        if vv < e._terminal_velocity then
            vv = e._terminal_velocity
        end
        e._vertical_velocity = vv
        local z = e.z + e._vertical_velocity

        if z > e.polygon.ceiling.z then
            z = e.polygon.ceiling.z
        elseif z < e.polygon.floor.z then
            z = e.polygon.floor.z
        end

        local x = e.x
        local y = e.y
        local poly = e.polygon
        x, y, poly = get_offset_location(e.x, e.y, e.z, e.polygon, e.facing, e._horizontal_dist)

        -- If hit a wall, try picking a new random direction to move in
        if not poly then
            local chdir = 90 + Game.random_local(45)
            if Game.random_local(2) == 0 then
                chdir = chdir * -1
            end
            e.facing = e.facing + chdir

            x, y, poly = get_offset_location(e.x, e.y, e.z, e.polygon, e.facing, e._horizontal_dist)

            if poly then
                e._horizontal_dist = e._horizontal_dist / 6
                if e._vertical_velocity > 0 then
                    e._vertical_velocity = e._vertical_velocity / 2
                end
            end
        end

        if not poly then
            x, y, poly = e.x, e.y, e.polygon
        end

        if poly then
            e:position(x, y, z, poly)
        end

        return e
    elseif e._delete_tick then
        return e
    elseif e._vertical_velocity <= -.09 then
        e._vertical_velocity = .03
        return e
    else
        e._active = false
        return nil
    end
end

function cleanup()
    local count = 0
    for e in Ephemera() do
        if count % 3 == 0 and e and not e._active then
            e:delete()
        end
        count = count + 1
    end
end

function get_offset_location(x, y, z, polygon, angle, dist)
    local nx, ny = calc_offset_location(x, y, angle, dist)
    local poly = get_polygon(polygon, x, y, nx, ny, z)

    return nx, ny, poly
end

function calc_offset_location(x, y, angle, dist)
    angle = angle * math.pi / 180
    return x + math.cos(angle) * dist, y + math.sin(angle) * dist
end

function get_polygon(start_poly, startx, starty, destx, desty, z)
    if start_poly:contains(destx, desty) then
        return start_poly
    end

    return get_poly_recurse(start_poly, startx, starty, destx, desty, z, 0)
end

function get_poly_recurse(start_poly, startx, starty, destx, desty, z, depth)
    local line = start_poly:find_line_crossed_leaving(startx, starty, destx, desty)
    if line then
        if line.cw_polygon == start_poly and line.ccw_polygon then
            newpoly = line.ccw_polygon
        elseif line.ccw_polygon == start_poly and line.cw_polygon then
            newpoly = line.cw_polygon
        end

        if newpoly then
            if newpoly:contains(destx, desty) then
                if z > newpoly.floor.height and z < newpoly.ceiling.height then
                    return newpoly
                else
                    return nil
                end
            else
                if depth > 3 then
                    return nil
                end
                return get_poly_recurse(newpoly, newpoly.x, newpoly.y, destx, desty, z, depth+1)                
            end
        else
            return nil
        end
    else
        return nil
    end
end

function get_ephemera_by_monster(m)
    local num = 8
    local col = m.type.collection

    if col == 13 then -- Use regular bob collection for vacbobs (m2 compatibility)
        col = 12
    end

    local seq = get_gore_sequence(col)
    local ct = m.type.clut_index

    if m.type.class == "juggernaut" then
        num = 30
    elseif m.type.class == "tick" then
        num = 5
    elseif m.type.class == "defender" then
        num = 30
    elseif m.type.class == "drone" or m.type.class == "possessed drone" then
        num = 6
    elseif m.type.class == "compiler" then
        num = 50
    elseif m.type == "mother of all cyborgs" or m.type == "mother of all hunters" then
        num = 20
    end

    if col == 7 then -- Items (potato anus, etc)
        num = 0
        seq = nil
    end

    return col, seq, ct, num
end

function get_ephemera_by_flaming_death()
    col = 4
    seq = 25 + Game.random_local(4)
    ct = 0

    return col, seq, ct, num
end

function get_gore_sequence(col)
    if col == 9 then
        return 13
    elseif col == 2 then
        return 9
    elseif col == 3 then
        return 7
    elseif col == 5 then
        return 11
    elseif col == 8 then
        return 10
    elseif col == 10 then
        return 9
    elseif col == 11 then
        return 14
    elseif col == 12 then
        return 13
    elseif col == 14 then
        return 8
    elseif col == 15 then
        return 8
    elseif col == 16 then
        return 8
    else
        return 9
    end
end
